IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Clientes_Insertar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Clientes_Insertar] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Clientes_Insertar]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por paremetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pRazon_Social VARCHAR(100)
DECLARE @pApellido VARCHAR(100)
DECLARE @pNombre VARCHAR(100)
DECLARE @pSexo CHAR(1)
DECLARE @pFecha_Nac DATETIME
DECLARE @pId_Tipo_Doc CHAR(3)
DECLARE @pDoc_Nro BIGINT
DECLARE @pIngresos_Brutos VARCHAR(20)
DECLARE @pDireccion VARCHAR(100)
DECLARE @pCp VARCHAR(10)
DECLARE @pId_Pais CHAR(3)
DECLARE @pId_Provincia CHAR(3)
DECLARE @pProvincia_Descrip VARCHAR(200)
DECLARE @pId_Localidad INT
DECLARE @pLocalidad_Descrip VARCHAR(200)
DECLARE @pFax VARCHAR(8000)
DECLARE @pCuit VARCHAR(13)
DECLARE @pEmail VARCHAR(8000)
DECLARE @pActivo TINYINT
DECLARE @pId_Estado_Cliente SMALLINT
DECLARE @pId_Grupo_Afinidad SMALLINT
DECLARE @pPorc_DescEspecial DECIMAL(5, 2)
DECLARE @pId_Lista_Precio SMALLINT
DECLARE @pId_Vendedor VARCHAR(10)
DECLARE @pId_Transportista VARCHAR(10)
DECLARE @pBonif DECIMAL(5, 2)
DECLARE @pId_Cond_Pago SMALLINT
DECLARE @pCred_CtaCte DECIMAL(12, 2)
DECLARE @pCred_ChePro DECIMAL(12, 2)
DECLARE @pCred_CheTer DECIMAL(12, 2)
DECLARE @pId_Iva CHAR(3)
DECLARE @pCTE VARCHAR(50)
DECLARE @pId_Concepto INT
DECLARE @pId_Cta_Banco SMALLINT
DECLARE @pId_Zona CHAR(5) 
DECLARE @pObservacion VARCHAR(8000)
DECLARE @pId_Cliente_Externo VARCHAR(14)
DECLARE @pId_Transporte INT
DECLARE @pId_Alias_Cta_Cont_Venta SMALLINT
DECLARE @pMercado CHAR(1)
DECLARE @pObserva_Fact VARCHAR(8000)
DECLARE @pEntre_Calle_1 VARCHAR(35) 
DECLARE @pEntre_Calle_2 VARCHAR(35) 
DECLARE @pPlano_Nro VARCHAR(10)
DECLARE @pPlano_Matriz VARCHAR(10)
DECLARE @pId_Cobrador VARCHAR(10)
DECLARE @pId_Motivo_Est SMALLINT
DECLARE @pId_Tipo_Cli SMALLINT
DECLARE @pId_Dep_Fisico CHAR(3)
DECLARE @pId_Dep_Logico CHAR(3)
DECLARE @pId_Tarjeta VARCHAR(10)
DECLARE @pId_Banco SMALLINT
DECLARE @pTar_Nro VARCHAR(25) 
DECLARE @pTar_Fecha_Vence DATETIME
DECLARE @pTar_Titular VARCHAR(50)
DECLARE @pDireccion_Cob VARCHAR(100)
DECLARE @pCp_Cob VARCHAR(10)
DECLARE @pId_Pais_Cob CHAR(3)
DECLARE @pId_Provincia_Cob CHAR(3)
DECLARE @pProvincia_Descrip_Cob VARCHAR(200)
DECLARE @pId_Localidad_Cob INT
DECLARE @pLocalidad_Descrip_Cob VARCHAR(200)
DECLARE @pEntre_Calle_1_Cob VARCHAR(35) 
DECLARE @pEntre_Calle_2_Cob VARCHAR(35) 
DECLARE @pPlano_Nro_Cob VARCHAR(10)
DECLARE @pPlano_Matriz_Cob VARCHAR(10)
DECLARE @pFecha_Ven_Trib DATETIME
DECLARE @pWeb VARCHAR(254)
DECLARE @pId_Cliente_Ref INT
DECLARE @pFecha_Alta DATETIME
DECLARE @pFecha_Baja DATETIME
DECLARE @pId_Centro_Costo CHAR(10)
DECLARE @pId_Promotor CHAR(10)
DECLARE @pNombre_Fantasia VARCHAR(100)
DECLARE @pId_Cond_Vta CHAR(10)
DECLARE @pId_Puerto CHAR(3)
DECLARE @pId_Calle INT
DECLARE @pNro INT
DECLARE @pDepto CHAR(10)
DECLARE @pFecha_Modif DATETIME
DECLARE @pFoto VARCHAR(254)
DECLARE @pLatitud DECIMAL(11, 7)  
DECLARE @pLongitud DECIMAL(11, 7)  
DECLARE @pId_Calle_Cob INT
DECLARE @pNro_Cob INT
DECLARE @pDepto_Cob VARCHAR(10)
DECLARE @pLatitud_Cob DECIMAL(11, 7)  
DECLARE @pLongitud_Cob DECIMAL(11, 7)  
DECLARE @pId_Precio_Especial INT
DECLARE @pCod_Autoriz_Trib VARCHAR(30)
DECLARE @pId_Alias_Cta_Cont_Venta_Dol SMALLINT
DECLARE @pEstado_Civil CHAR(1)
DECLARE @pId_Nacionalidad CHAR(3)
DECLARE @pId_Cli_Relac SMALLINT
DECLARE @pTipo_Persona CHAR(1)
DECLARE @ptelefono VARCHAR(900) 
DECLARE @pCalle_Descrip VARCHAR(100)
DECLARE @pCalle_Cob_Descrip VARCHAR(100)
DECLARE @pImp_Aporte DECIMAL(12, 2)
DECLARE @pFecha_Aporte DATETIME
DECLARE @pCredencial_Nro VARCHAR(30)
DECLARE @pCredencial_Banda1 VARCHAR(100)
DECLARE @pCredencial_Banda2 VARCHAR(100)
DECLARE @pCredencial_Imp SMALLINT
DECLARE @pUlt_Cuota_Paga DATETIME
DECLARE @pLegajo VARCHAR(30)
DECLARE @pCredencial_Entrega DATETIME
DECLARE @pId_Unid_Negocio CHAR(10)
DECLARE @pClave_Web VARCHAR(30)
DECLARE @pFlag_Anmat TINYINT
DECLARE @pNro_Anmat VARCHAR(26)
DECLARE @pTar_Cuit VARCHAR(13)
DECLARE @pId_Anmat CHAR(3)
DECLARE @pCoef_Comi_Vta DECIMAL(8, 4)
DECLARE @pCoef_Comi_Cobros DECIMAL(8, 4)
DECLARE @pEmail_Cob VARCHAR(254)
DECLARE @pRecorrido_Cob INT
DECLARE @pTar_Fecha_Alta DATETIME
DECLARE @pTar_Fecha_Baja DATETIME
DECLARE @pImp_Fac_Max_Mes DECIMAL(12, 2)
DECLARE @pEmail_Web VARCHAR(300)
DECLARE @pTel_Movil VARCHAR(20)
DECLARE @pFlag_Tel_Movil_Verif TINYINT
DECLARE @pFlag_Comunic_Sms TINYINT
DECLARE @pFlag_Comunic_Email TINYINT
DECLARE @pCarpeta VARCHAR(256)
DECLARE @pId_Emp_Area SMALLINT
DECLARE @pId_AR_ARBA_COT_Tipo_Dom_Nro VARCHAR(5)
DECLARE @pDir_Entrega_Numero SMALLINT
DECLARE @pDir_Entrega_Piso VARCHAR(3)
DECLARE @pDir_Entrega_Dto VARCHAR(4)
DECLARE @pDir_Entrega_Barrio VARCHAR(30)
DECLARE @pDir_Entrega_CP VARCHAR(8)
DECLARE @pDir_Entrega_Localidad VARCHAR(50)
DECLARE @pId_Usuario_Alta  SMALLINT 

SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pRazon_Social		= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Razon_Social')), '')
SET @pApellido			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Apellido')), '')
SET @pNombre			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Nombre')), '')
SET @pSexo				= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Sexo')), '')
SET @pFecha_Nac			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Nac')), '19000101')
SET @pId_Tipo_Doc		= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Doc')), '')
SET @pDoc_Nro			= ISNULL(CONVERT(BIGINT, dbo.CF_JSON_VALUE(@pJson,'Doc_Nro')), 0)
SET @pIngresos_Brutos	= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Ingresos_Brutos')), '')
SET @pDireccion			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Direccion')), '')
SET @pCp				= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Cp')), '')
SET @pId_Pais			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Pais')), '')
SET @pId_Provincia		= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Provincia')), '')
SET @pProvincia_Descrip = ISNULL(CONVERT(VARCHAR(200), dbo.CF_JSON_VALUE(@pJson,'Provincia_Descrip')), '')
SET @pId_Localidad		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Localidad')), 0)
SET @pLocalidad_Descrip = ISNULL(CONVERT(VARCHAR(200), dbo.CF_JSON_VALUE(@pJson,'Localidad_Descrip')), '')
SET @pFax				= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Fax')), 0)
SET @pCuit			    = ISNULL(CONVERT(VARCHAR(13), dbo.CF_JSON_VALUE(@pJson,'Cuit')), '')
SET @pEmail				= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Email')), 0)
SET @pActivo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Activo')), 0)
SET @pId_Estado_Cliente = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Estado_Cliente')), 0)
SET @pId_Grupo_Afinidad = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Grupo_Afinidad')), 0)
SET @pPorc_DescEspecial = ISNULL(CONVERT(DECIMAL(5, 2), dbo.CF_JSON_VALUE(@pJson,'Porc_DescEspecial')), 0)
SET @pId_Lista_Precio	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pId_Vendedor		= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Vendedor')), '')
SET @pId_Transportista  = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Transportista')), '')
SET @pBonif				= ISNULL(CONVERT(DECIMAL(5, 2), dbo.CF_JSON_VALUE(@pJson,'Bonif')), 0)
SET @pId_Cond_Pago		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Cond_Pago')), 0)
SET @pCred_CtaCte		= ISNULL(CONVERT(DECIMAL(12, 2), dbo.CF_JSON_VALUE(@pJson,'Cred_CtaCte')), 0)
SET @pCred_ChePro		= ISNULL(CONVERT(DECIMAL(12, 2), dbo.CF_JSON_VALUE(@pJson,'Cred_ChePro')), 0)
SET @pCred_CheTer		= ISNULL(CONVERT(DECIMAL(12, 2), dbo.CF_JSON_VALUE(@pJson,'Cred_CheTer')), 0)
SET @pId_Iva			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Iva')), '')
SET @pCTE				= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'CTE')), '')
SET @pId_Concepto		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Concepto')), 0)
SET @pId_Cta_Banco		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Cta_Banco')), 0)
SET @pId_Zona			= ISNULL(CONVERT(char(5), dbo.CF_JSON_VALUE(@pJson,'Id_Zona')), '')
SET @pObservacion		= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Observacion')), 0)
SET @pId_Cliente_Externo= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Cliente_Externo')), '')
SET @pId_Transporte		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Transporte')), 0)
SET @pId_Alias_Cta_Cont_Venta = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Cont_Venta')), 0)
SET @pMercado			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Mercado')), '')
SET @pObserva_Fact		= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Observa_Fact')), 0)
SET @pEntre_Calle_1		= ISNULL(CONVERT(varchar(35), dbo.CF_JSON_VALUE(@pJson,'Entre_Calle_1')), '')
SET @pEntre_Calle_2		= ISNULL(CONVERT(varchar(35), dbo.CF_JSON_VALUE(@pJson,'Entre_Calle_2')), '')
SET @pPlano_Nro			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Plano_Nro')), '')
SET @pPlano_Matriz		= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Plano_Matriz')), '')
SET @pId_Cobrador		= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cobrador')), '')
SET @pId_Motivo_Est		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Motivo_Est')), 0)
SET @pId_Tipo_Cli		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cli')), 0)
SET @pId_Dep_Fisico		= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Dep_Fisico')), '')
SET @pId_Dep_Logico		= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Dep_Logico')), '')
SET @pId_Tarjeta		= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Tarjeta')), '')
SET @pId_Banco			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Banco')), 0)
SET @pTar_Nro			= ISNULL(CONVERT(varchar(25), dbo.CF_JSON_VALUE(@pJson,'Tar_Nro')), '')
SET @pTar_Fecha_Vence	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Tar_Fecha_Vence')), '19000101')
SET @pTar_Titular		= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Tar_Titular')), '')
SET @pDireccion_Cob		= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Direccion_Cob')), '')
SET @pCp_Cob			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Cp_Cob')), '')
SET @pId_Pais_Cob		= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Pais_Cob')), '')
SET @pId_Provincia_Cob  = ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Provincia_Cob')), '')
SET @pProvincia_Descrip_Cob = ISNULL(CONVERT(VARCHAR(200), dbo.CF_JSON_VALUE(@pJson,'Provincia_Descrip_Cob')), '')
SET @pId_Localidad_Cob  = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Localidad_Cob')), 0)
SET @pLocalidad_Descrip_Cob = ISNULL(CONVERT(VARCHAR(200), dbo.CF_JSON_VALUE(@pJson,'Localidad_Descrip_Cob')), '')
SET @pEntre_Calle_1_Cob = ISNULL(CONVERT(varchar(35), dbo.CF_JSON_VALUE(@pJson,'Entre_Calle_1_Cob')), '')
SET @pEntre_Calle_2_Cob = ISNULL(CONVERT(varchar(35), dbo.CF_JSON_VALUE(@pJson,'Entre_Calle_2_Cob')), '')
SET @pPlano_Nro_Cob		= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Plano_Nro_Cob')), '')
SET @pPlano_Matriz_Cob  = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Plano_Matriz_Cob')), '')
SET @pFecha_Ven_Trib	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Ven_Trib')), '19000101')
SET @pWeb				= ISNULL(CONVERT(VARCHAR(254), dbo.CF_JSON_VALUE(@pJson,'Web')), '')
SET @pId_Cliente_Ref	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente_Ref')), 0)
SET @pFecha_Alta		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Alta')), '19000101')
SET @pFecha_Baja		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Baja')), '19000101')
SET @pId_Centro_Costo	= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), '')
SET @pId_Promotor		= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Promotor')), '')
SET @pNombre_Fantasia	= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Nombre_Fantasia')), '')
SET @pId_Cond_Vta		= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cond_Vta')), '')
SET @pId_Puerto			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Puerto')), '')
SET @pId_Calle			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Calle')), 0)
SET @pNro				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Nro')), 0)
SET @pDepto				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Depto')), '')
SET @pFecha_Modif		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Modif')), '19000101')
SET @pFoto				= ISNULL(CONVERT(VARCHAR(254), dbo.CF_JSON_VALUE(@pJson,'Foto')), '')
SET @pLatitud			= ISNULL(CONVERT(DECIMAL(11, 2), dbo.CF_JSON_VALUE(@pJson,'Latitud')), 0)
SET @pLongitud			= ISNULL(CONVERT(DECIMAL(11, 2), dbo.CF_JSON_VALUE(@pJson,'Longitud')), 0)
SET @pId_Calle_Cob		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Calle_Cob')), 0)
SET @pNro_Cob			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Nro_Cob')), 0)
SET @pDepto_Cob			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Depto_Cob')), '')
SET @pLatitud_Cob		= ISNULL(CONVERT(DECIMAL(11, 2), dbo.CF_JSON_VALUE(@pJson,'Latitud_Cob')), 0)
SET @pLongitud_Cob		= ISNULL(CONVERT(DECIMAL(11, 2), dbo.CF_JSON_VALUE(@pJson,'Longitud_Cob')), 0)
SET @pId_Precio_Especial= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Precio_Especial')), 0)
SET @pCod_Autoriz_Trib  = ISNULL(CONVERT(VARCHAR(30), dbo.CF_JSON_VALUE(@pJson,'Cod_Autoriz_Trib')), '')
SET @pId_Alias_Cta_Cont_Venta_Dol = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Cont_Venta_Dol')), 0)
SET @pEstado_Civil		= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Estado_Civil')), '')
SET @pId_Nacionalidad	= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Nacionalidad')), '')
SET @pId_Cli_Relac		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Cli_Relac')), 0)
SET @pTipo_Persona		= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Tipo_Persona')), '')
SET @ptelefono			= ISNULL(CONVERT(varchar(900), dbo.CF_JSON_VALUE(@pJson,'telefono')), '')
SET @pCalle_Descrip		= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Calle_Descrip')), '')
SET @pCalle_Cob_Descrip = ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Calle_Cob_Descrip')), '')
SET @pImp_Aporte		= ISNULL(CONVERT(DECIMAL(12, 2), dbo.CF_JSON_VALUE(@pJson,'Imp_Aporte')), 0)
SET @pFecha_Aporte		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Aporte')), '19000101')
SET @pCredencial_Nro	= ISNULL(CONVERT(VARCHAR(30), dbo.CF_JSON_VALUE(@pJson,'Credencial_Nro')), '')
SET @pCredencial_Banda1 = ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Credencial_Banda1')), '')
SET @pCredencial_Banda2 = ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Credencial_Banda2')), '')
SET @pCredencial_Imp	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Credencial_Imp')), 0)
SET @pUlt_Cuota_Paga	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Ult_Cuota_Paga')), '19000101')
SET @pLegajo			= ISNULL(CONVERT(VARCHAR(30), dbo.CF_JSON_VALUE(@pJson,'Legajo')), '')
SET @pCredencial_Entrega= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Credencial_Entrega')), '19000101')
SET @pId_Unid_Negocio	= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')
SET @pClave_Web			= ISNULL(CONVERT(VARCHAR(30), dbo.CF_JSON_VALUE(@pJson,'Clave_Web')), '')
SET @pFlag_Anmat		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Anmat')), 0)
SET @pNro_Anmat			= ISNULL(CONVERT(VARCHAR(26), dbo.CF_JSON_VALUE(@pJson,'Nro_Anmat')), '')
SET @pTar_Cuit			= ISNULL(CONVERT(VARCHAR(13), dbo.CF_JSON_VALUE(@pJson,'Tar_Cuit')), '')
SET @pId_Anmat			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Anmat')), '')
SET @pCoef_Comi_Vta		= ISNULL(CONVERT(DECIMAL(8, 2), dbo.CF_JSON_VALUE(@pJson,'Coef_Comi_Vta')), 0)
SET @pCoef_Comi_Cobros  = ISNULL(CONVERT(DECIMAL(8, 2), dbo.CF_JSON_VALUE(@pJson,'Coef_Comi_Cobros')), 0)
SET @pEmail_Cob			= ISNULL(CONVERT(VARCHAR(254), dbo.CF_JSON_VALUE(@pJson,'Email_Cob')), '')
SET @pRecorrido_Cob		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Recorrido_Cob')), 0)
SET @pTar_Fecha_Alta	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Tar_Fecha_Alta')), '19000101')
SET @pTar_Fecha_Baja	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Tar_Fecha_Baja')), '19000101')
SET @pImp_Fac_Max_Mes	= ISNULL(CONVERT(DECIMAL(12, 2), dbo.CF_JSON_VALUE(@pJson,'Imp_Fac_Max_Mes')), 0)
SET @pEmail_Web			= ISNULL(CONVERT(VARCHAR(300), dbo.CF_JSON_VALUE(@pJson,'Email_Web')), '')
SET @pTel_Movil			= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Tel_Movil')), '')
SET @pFlag_Tel_Movil_Verif = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Tel_Movil_Verif')), 0)
SET @pFlag_Comunic_Sms  = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Comunic_Sms')), 0)
SET @pFlag_Comunic_Email= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Comunic_Email')), 0)
SET @pCarpeta			= ISNULL(CONVERT(VARCHAR(256), dbo.CF_JSON_VALUE(@pJson,'Carpeta')), '')
SET @pId_Emp_Area		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Emp_Area')), 0)
SET @pId_AR_ARBA_COT_Tipo_Dom_Nro = ISNULL(CONVERT(VARCHAR(5), dbo.CF_JSON_VALUE(@pJson,'Id_AR_ARBA_COT_Tipo_Dom_Nro')), '')
SET @pDir_Entrega_Numero= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_Numero')), 0)
SET @pDir_Entrega_Piso  = ISNULL(CONVERT(VARCHAR(3), dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_Piso')), '')
SET @pDir_Entrega_Dto	= ISNULL(CONVERT(VARCHAR(4), dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_Dto')), '')
SET @pDir_Entrega_Barrio= ISNULL(CONVERT(VARCHAR(30), dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_Barrio')), '')
SET @pDir_Entrega_CP	= ISNULL(CONVERT(VARCHAR(8), dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_CP')), '')
SET @pDir_Entrega_Localidad = ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Dir_Entrega_Localidad')), '')
SET @pId_Usuario_Alta    = ISNULL(CONVERT(SMALLINT,	dbo.CF_JSON_VALUE(@pJson,'Id_Usuario_Alta"')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Id_Cliente		INT
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Clientes_Insertar'
		PRINT 'Parametros: '+ @pJson  
	END

	/*===================================================================*/

	IF(@pDoc_Nro = 0 AND @pCuit = '')
	BEGIN
		RAISERROR ('Parameters "Doc_Nro" or "Cuit" mandatory', 16,  1)
	END

	/*===================================================================*/
	
	IF(@pCuit <> '')
	BEGIN
		SET @Id_Cliente = ISNULL((SELECT TOP 1 ISNULL(Id_Cliente, 0) FROM Clientes WHERE LTRIM(RTRIM(Cuit)) = LTRIM(RTRIM(@pCuit)) ORDER BY Activo DESC, Id_Cliente DESC), 0)
	END

	IF(@Id_Cliente = 0 AND @pDoc_Nro <> 0)
	BEGIN
		SET @Id_Cliente = ISNULL((SELECT TOP 1 ISNULL(Id_Cliente, 0) FROM Clientes WHERE Doc_Nro = @pDoc_Nro ORDER BY Activo DESC, Id_Cliente DESC), 0)
	END

	/*===================================================================*/

	IF(@Id_Cliente = 0)
	BEGIN
		SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) + 1 FROM Clientes), 1)

		INSERT INTO Clientes
		(Id_Cliente,				Razon_Social,				Apellido,
		Nombre,						Sexo,						Fecha_Nac,
		Id_Tipo_Doc,				Doc_Nro,					Ingresos_Brutos,
		Direccion,					Cp,							Id_Pais,
		Id_Provincia,				Provincia_Descrip,			Id_Localidad,
		Localidad_Descrip,			Fax,						Cuit,
		Email,Activo,				Id_Estado_Cliente,			Id_Grupo_Afinidad,
		Porc_DescEspecial,			Id_Lista_Precio,			Id_Vendedor,
		Id_Transportista,			Bonif,						Id_Cond_Pago,
		Cred_CtaCte,				Cred_ChePro,Cred_CheTer,	Id_Iva,
		CTE,						Id_Concepto,				Id_Cta_Banco,
		Id_Zona,					Observacion,				Id_Cliente_Externo,
		Id_Transporte,				Id_Alias_Cta_Cont_Venta,	Mercado,
		Observa_Fact,				Entre_Calle_1,				Entre_Calle_2,
		Plano_Nro,					Plano_Matriz,				Id_Cobrador,
		Id_Motivo_Est,				Id_Tipo_Cli,				Id_Dep_Fisico,
		Id_Dep_Logico,				Id_Tarjeta,					Id_Banco,
		Tar_Nro,					Tar_Fecha_Vence,			Tar_Titular,
		Direccion_Cob,				Cp_Cob,						Id_Pais_Cob,
		Id_Provincia_Cob,			Provincia_Descrip_Cob,		Id_Localidad_Cob,
		Localidad_Descrip_Cob,		Entre_Calle_1_Cob,			Entre_Calle_2_Cob,
		Plano_Nro_Cob,				Plano_Matriz_Cob,			Fecha_Ven_Trib,
		Web,						Id_Cliente_Ref,				Fecha_Alta,
		Fecha_Baja,					Id_Centro_Costo,			Id_Promotor,
		Nombre_Fantasia,			Id_Cond_Vta,				Id_Puerto,
		Id_Calle,					Nro,						Depto,
		Fecha_Modif,				Foto,						Latitud,
		Longitud,					Id_Calle_Cob,				Nro_Cob,
		Depto_Cob,					Latitud_Cob,				Longitud_Cob,
		Id_Precio_Especial,			Cod_Autoriz_Trib,			Id_Alias_Cta_Cont_Venta_Dol,
		Estado_Civil,				Id_Nacionalidad,			Id_Cli_Relac,
		Tipo_Persona,				telefono,					Calle_Descrip,
		Calle_Cob_Descrip,			Imp_Aporte,					Fecha_Aporte,
		Credencial_Nro,				Credencial_Banda1,			Credencial_Banda2,
		Credencial_Imp,				Ult_Cuota_Paga,				Legajo,
		Credencial_Entrega,			Id_Unid_Negocio,			Clave_Web,
		Flag_Anmat,					Nro_Anmat,					Tar_Cuit,
		Id_Anmat,					Coef_Comi_Vta,				Coef_Comi_Cobros,
		Email_Cob,					Recorrido_Cob,				Tar_Fecha_Alta,
		Tar_Fecha_Baja,				Imp_Fac_Max_Mes,			Email_Web,
		Tel_Movil,					Flag_Tel_Movil_Verif,		Flag_Comunic_Sms,
		Flag_Comunic_Email,			Carpeta,					Id_Emp_Area,
		Id_AR_ARBA_COT_Tipo_Dom_Nro,Dir_Entrega_Numero,			Dir_Entrega_Piso,
		Dir_Entrega_Dto,			Dir_Entrega_Barrio,			Dir_Entrega_CP,
		Dir_Entrega_Localidad,		Id_Usuario_Alta)
		VALUES
		(@Id_Cliente,					@pRazon_Social,				@pApellido,
		@pNombre,						@pSexo,						@pFecha_Nac,
		@pId_Tipo_Doc,					@pDoc_Nro,					@pIngresos_Brutos,
		@pDireccion,					@pCp,						@pId_Pais,
		@pId_Provincia,					@pProvincia_Descrip,		@pId_Localidad,
		@pLocalidad_Descrip,			@pFax,						@pCuit,
		@pEmail,@pActivo,				@pId_Estado_Cliente,		@pId_Grupo_Afinidad,
		@pPorc_DescEspecial,			@pId_Lista_Precio,			@pId_Vendedor,
		@pId_Transportista,				@pBonif,					@pId_Cond_Pago,
		@pCred_CtaCte,					@pCred_ChePro,@pCred_CheTer,@pId_Iva,
		@pCTE,							@pId_Concepto,				@pId_Cta_Banco,
		@pId_Zona,						@pObservacion,				@pId_Cliente_Externo,
		@pId_Transporte,				@pId_Alias_Cta_Cont_Venta,	@pMercado,
		@pObserva_Fact,					@pEntre_Calle_1,			@pEntre_Calle_2,
		@pPlano_Nro,					@pPlano_Matriz,				@pId_Cobrador,
		@pId_Motivo_Est,				@pId_Tipo_Cli,				@pId_Dep_Fisico,
		@pId_Dep_Logico,				@pId_Tarjeta,				@pId_Banco,
		@pTar_Nro,						@pTar_Fecha_Vence,			@pTar_Titular,
		@pDireccion_Cob,				@pCp_Cob,					@pId_Pais_Cob,
		@pId_Provincia_Cob,				@pProvincia_Descrip_Cob,	@pId_Localidad_Cob,
		@pLocalidad_Descrip_Cob,		@pEntre_Calle_1_Cob,		@pEntre_Calle_2_Cob,
		@pPlano_Nro_Cob,				@pPlano_Matriz_Cob,			@pFecha_Ven_Trib,
		@pWeb,							@pId_Cliente_Ref,			@pFecha_Alta,
		@pFecha_Baja,					@pId_Centro_Costo,			@pId_Promotor,
		@pNombre_Fantasia,				@pId_Cond_Vta,				@pId_Puerto,
		@pId_Calle,						@pNro,						@pDepto,
		@pFecha_Modif,					@pFoto,						@pLatitud,
		@pLongitud,						@pId_Calle_Cob,				@pNro_Cob,
		@pDepto_Cob,					@pLatitud_Cob,				@pLongitud_Cob,
		@pId_Precio_Especial,			@pCod_Autoriz_Trib,			@pId_Alias_Cta_Cont_Venta_Dol,
		@pEstado_Civil,					@pId_Nacionalidad,			@pId_Cli_Relac,
		@pTipo_Persona,					@ptelefono,					@pCalle_Descrip,
		@pCalle_Cob_Descrip,			@pImp_Aporte,				@pFecha_Aporte,
		@pCredencial_Nro,				@pCredencial_Banda1,		@pCredencial_Banda2,
		@pCredencial_Imp,				@pUlt_Cuota_Paga,			@pLegajo,
		@pCredencial_Entrega,			@pId_Unid_Negocio,			@pClave_Web,
		@pFlag_Anmat,					@pNro_Anmat,				@pTar_Cuit,
		@pId_Anmat,						@pCoef_Comi_Vta,			@pCoef_Comi_Cobros,
		@pEmail_Cob,					@pRecorrido_Cob,			@pTar_Fecha_Alta,
		@pTar_Fecha_Baja,				@pImp_Fac_Max_Mes,			@pEmail_Web,
		@pTel_Movil,					@pFlag_Tel_Movil_Verif,		@pFlag_Comunic_Sms,
		@pFlag_Comunic_Email,			@pCarpeta,					@pId_Emp_Area,
		@pId_AR_ARBA_COT_Tipo_Dom_Nro,	@pDir_Entrega_Numero,		@pDir_Entrega_Piso,
		@pDir_Entrega_Dto,				@pDir_Entrega_Barrio,		@pDir_Entrega_CP,
		@pDir_Entrega_Localidad,		@pId_Usuario_Alta)
	END

	/*===================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT	 0							AS ErrorNumber 
			,0							AS ErrorSeverity  
			,0							AS ErrorState 
			,0							AS ErrorProcedure  
			,@Id_Cliente				AS ErrorLine		
			,''							AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Clientes_Insertar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 